<?php 

	session_start();
	
	if(!isset($_SESSION['contact_mobile'])){
		header("location: login.php");
	}
	
	require_once("includes/constants.php");
	require_once("includes/config_db.php");
	require_once("includes/config.php");
	require_once("includes/ZohoBooks.php");
	
	$current_page = "statements";
	
	
	if( isset($_SESSION['notify_msg']) && $_SESSION['notify_msg'] ){
		$notify_msg = $_SESSION['notify_msg'];
		unset($_SESSION['notify_msg']);
	}
	
	$customer_id = $_SESSION['contact_id'];
	
	$zb = new ZohoBooks(ZOHO_AUTHTOKEN, ZOHO_ORGANIZATIONID);
	
	if(isset($_POST['get-statement'])){
		
		extract($_POST);
		
		$start_date_arr = explode("/", $start_date);
		$start_date = $start_date_arr[2] . "-" . $start_date_arr[1] . "-" . $start_date_arr[0];
		
		$end_date_arr = explode("/", $end_date);
		$end_date = $end_date_arr[2] . "-" . $end_date_arr[1] . "-" . $end_date_arr[0];

		$config = array(
					"customer_id" => $customer_id,
					"start_date" => $start_date,
					"end_date" => $end_date,
				);

		$mailContent = $zb->getStatementMailContent($config);

		$response = json_decode($mailContent, true);
		
		// echo "<pre>";
		// print_r($response);
		// echo "</pre>";
		
		if( is_array($response) ){
		
			if( isset($response["message"]) && $response["message"] == "success" ){
				$to = $response["data"]["to_mails_str"];
				$subject = $response["data"]["subject"];
				$body = $response["data"]["body"];
				
				$mailData = array(
								"send_from_org_email_id" => true,
								"to_mail_ids" => array($to),
								"cc_mail_ids" => array(),
								"subject" => $subject,
								"body" => $body,
							);
				
				$mailResponse = $zb->postStatementMail($config, json_encode($mailData));
				
				$mailResponse = json_decode($mailResponse, true);
				
				if( is_array($mailResponse) && $mailResponse["code"] == 0 ){
					$_SESSION['notify_msg'] = '<div class="alert alert-success alert-dismissible">
													<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
													Statement mail sent successfully.
												</div>';
				}else{
					$_SESSION['notify_msg'] = '<div class="alert alert-danger alert-dismissible">
													<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
													Something went wrong, please try later.
												</div>';
				}
				header("location: statements.php");
				
				// echo "<pre>";
				// print_r($mailResponse);
				// echo "</pre>";
			}
		}
	}
	
	require_once("includes/header.php");
	require_once("includes/sidebar.php");
?>
	
	<?php if(isset($notify_msg) && $notify_msg != ""){ echo $notify_msg; } ?>
	
	<div class="row">
		<div class="col-12">
			<div class="d-flex flex-wrap justify-content-between">
				<div>
					<h3 class="card-title m-0 pt-3">Statements</h3>
				</div>
			</div>
			<hr>
			
			<div class="card">
				<div class="card-body">
					<h4 class="form-group">Select Date Range</h3>
					<form method="post" enctype="multipart/form-data">
						<div class="input-group input-daterange d-flex align-items-center form-group">
							<input type="text" class="form-control" name="start_date" placeholder="Start Date" required>
							<div class="input-group-addon mx-4">to</div>
							<input type="text" class="form-control" name="end_date" placeholder="End Date" required>
						</div>
						<div class="">
							<button class="btn btn-info" type="submit" name="get-statement" id="mailStatement">Email</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	
<?php 

	require_once("includes/footer.php");
	
?>