<?php 

	session_start();
	
	//$_SESSION['contact_mobile'] = 1234;
	
	if(isset($_SESSION['contact_mobile'])){
		header("location: index.php");
	}
	
	require_once("includes/config_db.php");
	require_once("includes/config.php");
	
	$notifyErr = "";
	$mobile_no = $otp = "";
	$mobileErr = $otpErr = "";
	if(isset($_POST['submit'])){
		if (empty($_POST["mobile_no"])){
			$mobileErr = "Please enter mobile number.";
		}else{
			$mobile_no = $_POST["mobile_no"];
		}
		
		if (empty($_POST["otp"])){
			$otpErr = "Please enter OTP.";
		}else{
			$otp = $_POST["otp"];
		}
			
		$sent_otp = $_POST['sent_otp'];
		
		if( $sent_otp == md5($otp) ){
			$_SESSION['contact_mobile'] = $mobile_no;
			session_save_path();
			header("location: index.php");
		}else{
			$notifyErr = '<div class="alert alert-warning alert-dismissible">'.
							'<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>'.
							'Wrong OTP, please try again.'.
						'</div>';
		}
	}
	
	if( isset($_SESSION["notify"]) ){
		$notifyErr = '<div class="alert alert-danger alert-dismissible">'.
							'<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>'.
							$_SESSION['notify'] .
						'</div>';
		unset($_SESSION['notify']);
	}

?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <title>Servius Client Portal | Log in</title>
        <!-- base:css -->
        <link rel="stylesheet" href="assets/css/materialdesignicons.min.css">
        <link rel="stylesheet" href="assets/css/vendor.bundle.base.css">
        <!-- endinject -->
        <!-- plugin css for this page -->
        <!-- End plugin css for this page -->
        <!-- inject:css -->
        <link rel="stylesheet" href="assets/css/vertical-layout-light/style.css">
        <link rel="stylesheet" href="assets/css/custom.css">
        <!-- endinject -->
        <link rel="shortcut icon" href="assets/images/favicon.png">
	</head>
	<body class="sidebar-fixed">
		
		<div id="mainLoader">
			<div class="loader-icon-wrapper">
				<div class="bar-loader">
					<span></span>
					<span></span>
					<span></span>
					<span></span>
				</div>
			</div>
		</div>
		
		<div class="container-scroller">
			<div class="container-fluid page-body-wrapper full-page-wrapper">
				<div class="content-wrapper d-flex align-items-center auth px-0">
					<div class="row w-100 mx-0">
						<div class="col-lg-4 mx-auto">
							<div class="auth-form-light text-center py-5 px-4 px-sm-5">
								<div class="brand-logo">
									<img src="assets/images/logo.png" alt="logo">
								</div>
								<h3>Login to the portal</h3>
								<h5>View your transactions with SERVIUS INFOTECH PVT. LTD.</h5>
								<div id="mainNotify" class="text-left">
									<?php  if(!empty($notifyErr)){echo $notifyErr;}?>
								</div>
								<form class="pt-3" method="post">
									<div class="form-group mobile-no-row">
										<label class="text-left d-block font-weight-bold">Mobile Number</label>
										<div class="input-group">
											<div class="input-group-prepend bg-transparent">
											  <span class="input-group-text bg-transparent border-right-0">
												<i class="mdi mdi-cellphone-android text-primary"></i>
											  </span>
											</div>
											<input type="number" class="form-control form-control-lg border-left-0" id="mobileNo" name="mobile_no" placeholder="Registered Mobile Number" value="<?php  if(!empty($mobile_no)) echo $mobile_no;?>" min="0" max="9999999999" required>
											<div class="input-group-append">
												<button class="btn btn-sm btn-info" id="getOtp" type="button">Get OTP</button>
											</div>
										</div>
										<span class="text-danger text-left d-block"><?php  echo $mobileErr;?></span>
									</div>
									<div class="form-group">
										<label class="text-left d-block font-weight-bold">OTP</label>
										<div class="input-group">
											<div class="input-group-prepend bg-transparent">
											  <span class="input-group-text bg-transparent border-right-0">
												<i class="mdi mdi-lock-outline text-primary"></i>
											  </span>
											</div>
											<input type="password" class="form-control form-control-lg border-left-0" id="otp" name="otp" placeholder="OTP" maxlength="6" required>
										</div>
										<span class="text-danger text-left d-block"><?php  echo $otpErr;?></span>
									</div>
									
									<div class="mt-3 row">
										<div class="col-6 pr-0">
											<button class="btn btn-block btn-primary font-weight-medium auth-form-btn disabled" type="submit" name="submit" id="signIn" disabled>SIGN IN</button>
										</div>
										<div class="col-6">
											<button class="btn btn-block btn-light  font-weight-medium auth-form-btn" type="button" id="cancelSignin">Cancel</button>
											<input type="hidden" id="sentOtpVal" name="sent_otp">
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
				<!-- content-wrapper ends -->
			</div>
			<!-- page-body-wrapper ends -->
		</div>
		<!-- container-scroller -->
        <!-- base:js -->
        <script src="assets/js/vendor.bundle.base.js"></script>
        <!-- endinject -->
        <!-- Plugin js for this page-->
        <!-- End plugin js for this page-->
        <!-- inject:js -->
        <script src="assets/js/off-canvas.js"></script>
        <script src="assets/js/hoverable-collapse.js"></script>
        <script src="assets/js/template.js"></script>
        <!-- endinject -->
        <!-- plugin js for this page -->
        <!-- End plugin js for this page -->
        <!-- Custom js for this page-->
		<script src="assets/js/pages/login.js"></script>
        <!-- End custom js for this page-->
	</body>
</html>
