<?php 

	session_start();
	
	if(!isset($_SESSION['contact_mobile'])){
		header("location: login.php");
	}
	
	require_once("includes/constants.php");
	require_once("includes/config_db.php");
	require_once("includes/config.php");
	require_once("includes/ZohoBooks.php");
	
	$current_page = "creditnotes";
	$page_no = 1;
	$next_page = $prev_page = $html_str = $status = $status_options = $creditnote_number = "";
	
	if( isset($_GET) && isset($_GET['page_no']) && intval($_GET['page_no']) > 0 ){
		$page_no = intval($_GET['page_no']);
	}
	
	if( isset($_GET) && isset($_GET['status']) && $_GET['status'] != "" ){
		$status = $_GET['status'];
	}
	
	if( isset($_POST['search-creditnote']) ){
		$creditnote_number = $_POST['creditnote_number'];
	}
	
	$status_options .= ($status=="" || $status=="Status.All") ? '<option value="Status.All" selected>All</option>' : '<option value="Status.All">All</option>';
	$status_options .= ($status=="Status.Closed") ? '<option value="Status.Closed" selected>Closed</option>' : '<option value="Status.Closed">Closed</option>';
	$status_options .= ($status=="Status.Draft") ? '<option value="Status.Draft" selected>Draft</option>' : '<option value="Status.Draft">Draft</option>';
	$status_options .= ($status=="Status.Open") ? '<option value="Status.Open" selected>Open</option>' : '<option value="Status.Open">Open</option>';
	$status_options .= ($status=="Status.Void") ? '<option value="Status.Void" selected>Void</option>' : '<option value="Status.Void">Void</option>';
	
	$zb = new ZohoBooks(ZOHO_AUTHTOKEN, ZOHO_ORGANIZATIONID);
	
	$config = array(
					"customer_id" => $_SESSION['contact_id'],
					"page" => $page_no,
				);
	
	if( $status != "" ){
		$config["filter_by"] = $status;
	}
	if( $creditnote_number != "" ){
		$config["creditnote_number"] = $creditnote_number;
	}

	$creditnotes = $zb->allCreditNotes($config);
	

	$response = json_decode($creditnotes, true);
	
	if( is_array($response) ){
		$creditnotes = $response['creditnotes'];
		$page_context = $response['page_context'];
		$max = sizeof($creditnotes);
		
		/*echo "<pre>";
		print_r($creditnotes[0]);
		echo "</pre>";
		
		echo "<pre>";
		print_r($page_context);
		echo "</pre>";*/
		
		for($i=0; $i<$max; $i++){
			$status_class = "badge-dark";
		
			if( $creditnotes[$i]['status'] == "closed" ){
				$status_class = "badge-success";
			}else if( $creditnotes[$i]['status'] == "draft" ){
				$status_class = "badge-secondary";
			}else if( $creditnotes[$i]['status'] == "open" ){
				$status_class = "badge-info";
			}else if( $creditnotes[$i]['status'] == "void" ){
				$status_class = "badge-dark";
			}
			
			$html_str .= '<tr>
							<td>'. $creditnotes[$i]['creditnote_number'] .'</td>
							<td>'. date('d-M-Y', strtotime($creditnotes[$i]['date'])) .'</td>
							<td><i class="fa fa-rupee"></i> '. $creditnotes[$i]['total'] .'</td>
							<td><span class="badge '. $status_class .'">'. ucfirst($creditnotes[$i]['status']) .'</span></td>
							<td><a href="download.php?creditnote_id='. $creditnotes[$i]['creditnote_id'] .'&creditnote_number='. $creditnotes[$i]['creditnote_number'] .'" target="_blank"><i class="fa fa-cloud-download" style="font-size: 1.3rem;"></i></a></td>
						</tr>';
		}
		
		if( $page_no > 1 ){
			$prev_page = "creditnotes.php?page_no=" . ($page_no - 1);
			
			if( isset($_GET) && isset($_GET['status']) && $_GET['status'] != "" ){
				$prev_page .= "&status=" . $_GET['status'];
			}
		}
		
		if( $page_context['has_more_page'] ){
			$page_no++;
			
			$next_page = "creditnotes.php?page_no=" . $page_no;
			
			if( isset($_GET) && isset($_GET['status']) && $_GET['status'] != "" ){
				$next_page .= "&status=" . $_GET['status'];
			}
		}
	}
	
	require_once("includes/header.php");
	require_once("includes/sidebar.php");
?>
	
	<div class="row">
		<div class="col-12">
			<div class="d-flex flex-wrap justify-content-between">
				<div>
					<h3 class="card-title m-0 pt-3">Credit Notes</h3>
				</div>
				<div>
					<div class="d-flex align-items-center">
						<select class="form-control" id="statusFltr">
							<?php echo $status_options; ?>
						</select>
					</div>
				</div>
			</div>
			<hr>
			<div class="card">
				<div class="card-body">
					<div class="row">
						<div class="col"></div>
						<div class="col-4">
							<div class="form-group">
								<form method="POST" action="">
									<div class="input-group">
										<div class="input-group-prepend">
											<span class="input-group-text">Credit Note Number</span>
										</div>
										<input type="text" class="form-control" name="creditnote_number" value="<?php if(isset($creditnote_number) && $creditnote_number != ""){ echo $creditnote_number; } ?>">
										<div class="input-group-append">
											<button class="btn btn-sm btn-primary" name="search-creditnote" type="submit">Search</button>
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
					<div class="table-responsive">
						<table class="table table-hover">
							<thead>
								<tr>
									<th>Credit Note Number</th>
									<th>Date</th>
									<th>Total</th>
									<th>Status</th>
									<th>Download</th>
								</tr>
							</thead>
							<tbody>
								<?php echo $html_str; ?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
			
			<?php if( (isset($prev_page) && $prev_page != "") || (isset($next_page) && $next_page != "") ){ ?>
			<div class="row mt-4">
				<div class="col-auto">
					<?php if(isset($prev_page) && $prev_page != ""){ ?>
					<a href="<?php echo $prev_page; ?>" class="btn btn-inverse-dark btn-fw">Previous</a>
					<?php } ?>
				</div>
				<div class="col"></div>
				<div class="col-auto">
					<?php if(isset($next_page) && $next_page != ""){ ?>
					<a href="<?php echo $next_page; ?>" class="btn btn-inverse-dark btn-fw">Next</a>
					<?php } ?>
				</div>
			</div>
			<?php }?>
		</div>
	</div>
	
<?php 

	require_once("includes/footer.php");
	
?>
                    