<?php 

	session_start();
	
	if(!isset($_SESSION['contact_mobile'])){
		header("location: login.php");
	}
	
	require_once("includes/constants.php");
	require_once("includes/config_db.php");
	require_once("includes/config.php");
	require_once("includes/ZohoBooks.php");
	
	$current_page = "contactus";
	$notify_msg = "";
	
	$contact_mobile = $_SESSION['contact_mobile'];
	$customer_id = $_SESSION['contact_id'];
	$req_tbl_data = "";
	
	if( isset($_SESSION['notify_msg']) && $_SESSION['notify_msg'] ){
		$notify_msg = $_SESSION['notify_msg'];
		unset($_SESSION['notify_msg']);
	}
	
	if(isset($_POST['add-complaint'])){
		
		extract($_POST);
		
		if(!empty($description)){
			$description = addslashes($description);
			$status = "Registered";
			try{
				$sql_query = "INSERT INTO complaints(`mobile_no`, `customer_id`, `complaint_type`, `complaint_desc`, `status`) VALUES ('$contact_mobile','$customer_id','$request_related','$description','$status')";
				$stmt = $dbh->query($sql_query);
				$complaint_id = $dbh->lastInsertId();
				
				$sql_query = "INSERT INTO complaint_history(`complaint_id`, `status`, `remark`) VALUES ('$complaint_id','$status','$description')";
				$stmt = $dbh->query($sql_query);
				$complaint_id = $dbh->lastInsertId();
				
				$_SESSION['notify_msg'] = '<div class="alert alert-success alert-dismissible">
													<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
													Your request created successfully.
												</div>';
				header("location: contactus.php");
			}
			catch(PDOException $ex){
				DBLogError($ex->getCode(), $ex->getMessage(),$ex->getFile(),$ex->getLine(),$ex->getTraceAsString(),'1');
				
				$_SESSION['notify_msg'] = $ex->getMessage();
				header("location: contactus.php");
			}
		}else{
			$_SESSION['notify_msg'] = '<div class="alert alert-danger alert-dismissible">
										<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
										All(*)Field are Required.
									</div>';
			header("location: contactus.php");
		}
	}
	
	$sql_query = "SELECT * FROM complaints WHERE customer_id='$customer_id' ORDER BY complaint_id DESC";
	$stmt = $dbh->query($sql_query);
	
	while($row = $stmt->fetch( PDO::FETCH_ASSOC)){
		$complaint_id = $row['complaint_id'];
		$mobile_no = $row['mobile_no'];
		$customer_id = $row['customer_id'];
		$complaint_type = $row['complaint_type'];
		$complaint_desc = $row['complaint_desc'];
		$status = $row['status'];
		$created_on = date("d/m/Y H:i:s", strtotime($row['created_on']));
		$updated_on = ($row['updated_on']!="" && $row['updated_on']!=NULL) ? date("d/m/Y H:i:s", strtotime($row['updated_on'])) : "" ;
		
		if( $status == "Registered" ){
			$status = '<span class="badge badge-warning">Registered</span>';
		}else if( $status == "In Progress" ){
			$status = '<span class="badge badge-info">In Progress</span>';
		}else if( $status == "Resolved" ){
			$status = '<span class="badge badge-success">Resolved</span>';
		}
		
		$req_tbl_data .= "<tr data-complaint-id='$complaint_id'>".
							"<td>$complaint_type</td>".
							"<td>$complaint_desc</td>".
							"<td>$status</td>".
							"<td>$created_on</td>".
							"<td>$updated_on</td>".
							"<td><button class='btn btn-dark complaint-history'>History</button></td>".
						"</tr>";
	}
	
	require_once("includes/header.php");
	require_once("includes/sidebar.php");
?>
	
	<?php if(isset($notify_msg) && $notify_msg != ""){ echo $notify_msg; } ?>
	
	<div class="row">
		<div class="col">
			<h3>Contact Us</h3>
			<hr>
			<div class="row">
				<div class="col">
					<div class="card mb-3">
						<div class="card-body">
							<h4 class="text-primary">Raise Request</h4>
							
							<form method="post" name="submit" enctype="multipart/form-data" id="chequeDepositForm">
								<div class="form-group">
									<label>Request Related <span class="text-danger">* </span></label>
									<select class="form-control" id="requestRelated" name="request_related">
										<option value="Invoice">Invoice</option>
										<option value="Estimate">Estimate</option>
										<option value="Payment">Payment</option>
										<option value="Statement">Statement</option>
										<option value="Credit Note">Credit Note</option>
										<option value="RMA">RMA</option>
									</select>
								</div>
								
								<div class="form-group">
									<label>Description <span class="text-danger">* </span></label>
									<textarea class="form-control" id="description" name="description" rows="5" maxlength="255" required></textarea>
								</div>
								
								<button class="btn btn-primary" type="submit" name="add-complaint">Submit</button>
							</form>
						</div>
					</div>
							
					<div class="card mb-3">
						<div class="card-body">
							<h4 class="text-primary">Your Requests</h4>
							<div class="table-responsive">
								<table class="table" id="requestTbl">
									<thead>
										<tr>
											<th>Related</th>
											<th>Description</th>
											<th>Status</th>
											<th>Created On</th>
											<th>Updated On</th>
											<th>History</th>
										</tr>
									</thead>
									<tbody>
										<?php if(isset($req_tbl_data)){ echo $req_tbl_data; } ?>
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
				<div class="col">
					<div class="card mb-3">
						<div class="card-body">
							<h4 class="text-primary">Contact Details</h4>
							<ul class="contact-detail p-0 m-0">
                                <li>
                                    <address>
                                       <b>SERVIUS IT SERVICES (P) LIMITED</b> <br>
44, Zone - 1, MP Nagar, Bhopal Madhya Pradesh, 462011, IN<br>
CIN : U72200MP2015PTC034176
                                    </address>
                                </li>
                                <li>
                                    <span class="contact-detail-icon"><i class="mdi mdi-phone-classic"></i></span> 0755-4007707 &nbsp;&nbsp;
                                    <span class="contact-detail-icon"><i class="mdi mdi-email-outline"></i></span> <a href="#">info@servius.in</a>
                                </li>
                            </ul>
						</div>
					</div>
					
					<div class="card mb-3">
						<div class="card-body">
							<h4 class="text-primary">Sales</h4>
							<ul class="contact-detail p-0 m-0">
                                <li>
                                    <span class="contact-detail-icon"><i class="mdi mdi-cellphone-android"></i></span> 9981971234, 9981136033 &nbsp;&nbsp;
								</li>
								<li>
                                    <span class="contact-detail-icon"><i class="mdi mdi-email-outline"></i></span> <a href="#">sales@servius.in</a>
                                </li>
                            </ul>
						</div>
					</div>
					
					<div class="card mb-3">
						<div class="card-body">
							<h4 class="text-primary">TECHNICAL SUPPORT</h4>
							<ul class="contact-detail p-0 m-0">
                                <li>
                                    <span class="contact-detail-icon"><i class="mdi mdi-cellphone-android"></i></span> 7748061874
								</li>
								<li>
                                    <span class="contact-detail-icon"><i class="mdi mdi-email-outline"></i></span> <a href="#">support@servius.in</a>
                                </li>
                            </ul>
						</div>
					</div>
					
					<div class="card">
						<div class="card-body">
							<h4 class="text-primary">RMA SUPPORT</h4>
							<ul class="contact-detail p-0 m-0">
                                <li>
                                    <span class="contact-detail-icon"><i class="mdi mdi-cellphone-android"></i></span> 9752329932
								</li>
								<li>
                                    <span class="contact-detail-icon"><i class="mdi mdi-email-outline"></i></span> <a href="#">rma@servius.in</a>
                                </li>
                            </ul>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	
	<div class="modal fade" id="requestHistoryModal">
        <div class="modal-dialog">
            <div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title">Request History</h4>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<table class="table" id="requestHistoryTbl">
						<thead>
							<tr>
								<th>Remark</th>
								<th>Date</th>
								<th>Status</th>
							</tr>
						</thead>
						<tbody>
						</tbody>
					</table>
				</div>
            </div>
        </div>
    </div>
	
<?php 

	require_once("includes/footer.php");
	
?>
                    