<?php 

	session_start();
	
	if(!isset($_SESSION['contact_mobile'])){
		header("location: login.php");
	}else{
		require_once("includes/constants.php");
		require_once("includes/config_db.php");
		require_once("includes/config.php");
		require_once("includes/ZohoBooks.php");
		
		$current_page = "dashboard";
		
		$contact_mobile = $_SESSION['contact_mobile'];
		
		$outstanding_amt = $overdue_amt = $unused_amt = 0;
		
		$zb = new ZohoBooks(ZOHO_AUTHTOKEN, ZOHO_ORGANIZATIONID);
		
		$config = array(
						"phone_contains" => "9981112214",
						//"phone_contains" => $contact_mobile,
						//"phone_startswith" => "9981112214",
					);

		$contacts = $zb->allContacts($config);
			
		$response = json_decode($contacts, true);
		
		if( is_array($response) ){
			if( sizeof($response['contacts']) ){
				$contacts = $response['contacts'];
				$contact_id = $contacts[0]["contact_id"];
				$contact_name = $contacts[0]["contact_name"];
				$contact_email = $contacts[0]["email"];
				$contact_mobile = $contacts[0]["mobile"];
				
				$_SESSION['contact_id'] = $contact_id;
				$_SESSION['contact_name'] = $contact_name;
				$_SESSION['contact_email'] = $contact_email;
				$_SESSION['contact_mobile'] = $contact_mobile;
				
				$contact_data = $zb->getContact($contact_id);
				
				$contact_response = json_decode($contact_data, true);
			
				if( is_array($contact_response) ){
					/*echo "<pre>";
					print_r($contact_response);
					echo "</pre>";*/
					
					$contact = $contact_response["contact"];
					$outstanding_amt = $contact["outstanding_receivable_amount"];
					//$overdue_amt = $contact["outstanding_receivable_amount"];
					$unused_amt = $contact["unused_credits_receivable_amount"];
					$company_name = $contact["company_name"];
					$contact_person = $contact["contact_persons"][0]["salutation"] . " " . $contact["contact_persons"][0]["first_name"] ." ". $contact["contact_persons"][0]["last_name"];
					$contact_email = $contact["contact_persons"][0]["email"];
					$contact_mobile = $contact["contact_persons"][0]["mobile"];
					$gst_no = $contact["gst_no"];
					$gst_treatment = $contact["gst_treatment"];
					$credit_limit = $contact["credit_limit"];
					$custom_fields = $contact["custom_fields"];
					$billing_address = $contact["billing_address"]["address"];
					//$billing_address .= " " . $contact["billing_address"]["city"];
					//$billing_address .= " " . $contact["billing_address"]["state"];
					//$billing_address .= " " . $contact["billing_address"]["zip"];
					//$billing_address .= " " . $contact["billing_address"]["country"];
					$shipping_address = $contact["shipping_address"]["address"];
					//$shipping_address .= " " . $contact["shipping_address"]["city"];
					//$shipping_address .= " " . $contact["shipping_address"]["state"];
					//$shipping_address .= " " . $contact["shipping_address"]["zip"];
					//$shipping_address .= " " . $contact["shipping_address"]["country"];
					
					for($i=0; $i<sizeof($custom_fields); $i++){
						if( $custom_fields[$i]["label"] == "Account Status" ){
							$account_status = $custom_fields[$i]["value_formatted"];
						}else if( $custom_fields[$i]["label"] == "Account Type" ){
							$account_type = $custom_fields[$i]["value_formatted"];
						}else if( $custom_fields[$i]["label"] == "Bank Name" ){
							$bank_name = $custom_fields[$i]["value_formatted"];
						}else if( $custom_fields[$i]["label"] == "Beneficiary Name" ){
							$beneficiary_name = $custom_fields[$i]["value_formatted"];
						}else if( $custom_fields[$i]["label"] == "Virtual AC No" ){
							$virtual_ac_no = $custom_fields[$i]["value_formatted"];
						}else if( $custom_fields[$i]["label"] == "IFSC Code" ){
							$ifsc_code = $custom_fields[$i]["value_formatted"];
						}else if( $custom_fields[$i]["label"] == "Branch" ){
							$branch = $custom_fields[$i]["value_formatted"];
						}
					}
				}
			}else{
				$_SESSION["notify"] = "Account not found for ". $_SESSION["contact_mobile"] ." mobile number";
				unset($_SESSION['contact_mobile']);
				header("location:login.php");
			}
		}
	}
	
	require_once("includes/header.php");
	require_once("includes/sidebar.php");
?>
	
	<div class="row">
		<div class="col">
			<h3>Welcome <?php if(isset($company_name)){ echo $company_name; } ?>,</h3>
			<hr>
			<div class="row">
				<div class="col-12 mb-3 stretch-card">
					<div class="card">
						<div class="card-body">
							<h4 class="">Outstanding Amount</h4>
							<h2 class="text-danger"><?php echo $outstanding_amt; ?></h2>
							<a href="invoices.php?status=unpaid">
							    <h6 class="text-muted m-0">View All unpaid Invoices</h6>
							</a>
						</div>
					</div>
				</div>
				<div class="col-12 mb-3 stretch-card">
					<div class="card">
						<div class="card-body">
							<h4 class="text-success">Unused Credits</h4>
							<h2 class="text-success"><?php echo $unused_amt; ?></h2>
						</div>
					</div>
				</div>
				<div class="col-12 mb-3 stretch-card">
					<div class="card">
						<div class="card-body">
							<a class="btn btn-info btn-block py-3" href="invoices.php?status=overdue">View All overdue Invoices</a>
						</div>
					</div>
				</div>
			</div>
			
			<div class="row">
				<div class="col-12 mb-3 stretch-card">
					<div class="card">
						<div class="card-body">
							<h4 class="text-info">My Account Details</h4>
							<h6>Company Name: <span class="text-muted"><?php if(isset($company_name)){ echo $company_name; } ?></span></h6>
							<h6>Contact Person: <span class="text-muted"><?php if(isset($contact_person)){ echo $contact_person; } ?></span></h6>
							<h6>Email ID: <span class="text-muted"><?php if(isset($contact_email)){ echo $contact_email; } ?></span></h6>
							<h6>Mobile No.: <span class="text-muted"><?php if(isset($contact_mobile)){ echo $contact_mobile; } ?></span></h6>
							<h6>GST Treatment: <span class="text-muted"><?php if(isset($gst_treatment)){ echo $gst_treatment; } ?></span></h6>
							<h6>GSTIN: <span class="text-muted"><?php if(isset($gst_no)){ echo $gst_no; } ?></span></h6>
							<h6>Account type: <span class="text-muted"><?php if(isset($account_type)){ echo $account_type; } ?></span></h6>
							<h6>Credit Limit: <span class="text-muted"><?php if(isset($credit_limit)){ echo $credit_limit; } ?></span></h6>
						</div>
					</div>
				</div>
				<div class="col-12 mb-3 stretch-card">
					<div class="card">
						<div class="card-body">
							<h4 class="text-info">Billing Address</h4>
							<h6><span class="text-muted"><?php if(isset($billing_address)){ echo $billing_address; } ?></span></h6>
						</div>
					</div>
				</div>
					
				<div class="col-12 mb-3 stretch-card">
					<div class="card">
						<div class="card-body">
							<h4 class="text-info">Shipping Address</h4>
							<h6><span class="text-muted"><?php if(isset($shipping_address)){ echo $shipping_address; } ?></span></h6>
						</div>
					</div>
				</div>
			</div>
			
			<div class="row">
				<div class="col-12 stretch-card">
					<div class="card">
						<div class="card-body">
							<h4 class="text-info">Bank Detail</h4>
							<h6>Bank Name: <span class="text-muted"><?php if(isset($bank_name)){ echo $bank_name; } ?></span></h6>
							<h6>Beneficiary Name: <span class="text-muted"><?php if(isset($beneficiary_name)){ echo $beneficiary_name; } ?></span></h6>
							<h6>Virtual AC No: <span class="text-muted"><?php if(isset($virtual_ac_no)){ echo $virtual_ac_no; } ?></span></h6>
							<h6>Branch: <span class="text-muted"><?php if(isset($branch)){ echo $branch; } ?></span></h6>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	
<?php 

	require_once("includes/footer.php");
	
?>
                    