(function($) {
	'use strict';
	$(function() {
		
		$("body").on("click", ".adtnl-info", function(){
			
			var tr = $(this);
			var warranty = (tr.attr("data-warranty")=="1") ? "<span class='text-success'>Yes</span>" : "<span class='text-warning'>No</span>";
			var status = tr.attr("data-status");
			var stsClass = "";
			
			if(status=='Pending'){
				stsClass = "text-danger";
			}else if(status=='Delivered'){
				stsClass = "text-success";
			}
	
			var statusText = "<span class='" + stsClass + "'>" + status + "</span>";
			var imageName = tr.attr("data-image");
			var imageUrl = (imageName!="") ? "<a href='"+imageName+"' target='_blank' class='btn btn-info'><i class='mdi mdi-image'> View</i></a>" : "";
	
			$("#iRmaNo").html( tr.attr("data-id") );
			$("#iSrNo").html( tr.attr("data-sr") );
			$("#iPrd").html( tr.attr("data-pname") );
			$("#iCusNm").html( tr.attr("data-cusname") );
			$("#iCusMblNo").html( tr.attr("data-mobile") );
			$("#iCntctPrsn").html( tr.attr("data-cntct-prsn") );
			$("#iAddrss").html( tr.attr("data-address") );
			$("#iWarranty").html( warranty );
			$("#iRegDt").html( tr.attr("data-regdate") );
			$("#iInvc").html( tr.attr("data-invoice") );
			$("#iInvcDt").html( tr.attr("data-invcdate") );
			$("#iSrvcChrg").html( tr.attr("data-charge") );
			$("#iSrvcChrgRmk").html( tr.attr("data-chargeremark") );
			$("#iSts").html( statusText );
			$("#iImg").html( imageUrl );
			
			if( parseInt(tr.attr("data-charge")) > 0 ){
				$("#iTxnid").html( tr.attr("data-txnid") );
				$("#iPymtDt").html( tr.attr("data-payment-date") );
				
				if( tr.attr("data-payment-status") == "Success"){
					$("#iPymtSts").html( "<span class='text-success'>Success</span>" );
				}else{
					$("#iPymtSts").html( "<span class='text-danger'>Pending</span>" );
				}
				$("#iTxnidRow, #iPymtDtRow, #iPymtStsRow").show();
			}else{
				$("#iTxnid, #iPymtDt, #iPymtSts").html("");
				$("#iTxnidRow, #iPymtDtRow, #iPymtStsRow").hide();
			}
			
			$("#adtnl-info-modal").modal("show");
		});
	});
})(jQuery);