(function($) {
	'use strict';
	$(function() {
		
		$("#signin").click(function(){
			var mobileNo = $("#mobileNo").val().trim();
			var otp = $("#otp").val().trim();
			
			if( mobileNo != "" && otp != "" ){
				$("#mainLoader").show();
			}
		});
		
		$("#cancelSignin").click(function(){
			$("#signIn").attr("disabled", "disabled");
			$("#signIn").addClass("disabled");
			$("#mobileNo").removeAttr("readonly");
			$("#sentOtpVal").val("");
		});
		
		$("#getOtp").click(function(){
			$(".mobile-no-row #mobileNo, .mobile-no-row .input-group-text").removeClass("border-danger");
			
			var mobileNo = $("#mobileNo").val().trim();
			
			if( mobileNo == "" ){
				$(".mobile-no-row #mobileNo, .mobile-no-row .input-group-text").addClass("border-danger");
			}else{
				$("#mainLoader").show();
				
				$.ajax({
					type: "POST",
					url: "ajax/ajaxCall.php",
					dataType: "json",
					data: {
						method: 'sendOtp',
						mobileNo: mobileNo
					},
					success: function(response){
						if( response.otp != undefined && response.otp != "" ){
							$("#sentOtpVal").val(response.otp);
							$("#signIn").removeAttr("disabled");
							$("#signIn").removeClass("disabled");
							$("#mobileNo").attr("readonly", "readonly");
						}
						setTimeout(function(){
							var notify = '<div class="alert alert-success alert-dismissible">'+
											'<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>'+
											'OTP sent to '+ mobileNo +
										'</div>';
							$("#mainNotify").html(notify);
							$("#mainLoader").hide();
							
							setTimeout(function(){
								$("#mainNotify").html("");
							}, 5000);
						}, 1000);
					},
					error: function( jqXHR, textStatus, errorThrown){
						console.log(jqXHR);
						console.log(textStatus);
						console.log(errorThrown);
						$("#mainLoader").hide();
					}
				});
			}
		});
		
	});
})(jQuery);