<?php 

	session_start();
	
	if(!isset($_SESSION['contact_mobile'])){
		header("location: login.php");
	}
	
	require_once("includes/constants.php");
	require_once("includes/config_db.php");
	require_once("includes/config.php");
	require_once("includes/ZohoBooks.php");
	
	$current_page = "rmadevices";
	
	$contact_mobile = $_SESSION['contact_mobile'];
	$html_str = "";
	$download_btn = "";
	
	$sql_query = "SELECT * FROM services WHERE mobile=$contact_mobile ORDER BY id DESC ";
	$stmt = $dbh->query($sql_query);
	while($row = $stmt->fetch( PDO::FETCH_ASSOC)){
		$id = $row['id'];
		$sr = $row['sr'];
		$pname = $row['pname'];
		$cus_name = $row['name'];
		$mobile = $row['mobile'];
		$contact_person = $row['contact_person'];
		$address = $row['address'];
		$warranty = $row['warranty'];
		$history = "<button class='btn btn-sm btn-link request-history p-0'>History</button>";
		$reg_date = ($row['date']!="" && $row['date']!=null && $row['date']!="NA") ? date('d-M-Y', strtotime($row['date'])) : "";
		$invoice = $row['invoice'];
		$invoice_date = ($row['invoice_date']!="" && $row['invoice_date']!=null && $row['invoice_date']!="NA") ? date('d-M-Y', strtotime($row['invoice_date'])) : "";
		$charge = floatval($row['charge']);
		$charge_remark = $row['charge_remark'];
		$image = ($row['image'] != "") ? $_SERVER['HTTP_HOST'] . '/control-panel/uploads/' . $row['image'] : "";
		$status = $row['status'];
		$txnid = $row['txnid'];
		$payment_date = ($row['payment_date']!="" && $row['payment_date']!=null && $row['payment_date']!="NA") ? date('d-M-Y', strtotime($row['payment_date'])) : "";
		$payment_status = $row['payment_status'];

		$sts_class = "badge-dark";
		if($status=='Pending'){
			$sts_class = "badge-danger";
		}else if($status=='Delivered'){
			$sts_class = "badge-success";
		}
		
		$status_text = "<span class='badge $sts_class'>$status</span>";
		$warranty_text = ($warranty) ? "<span class='text-success'>Yes</span>" : "<span class='text-warning'>No</span>";
		$warranty = ($row['warranty']) ? "Yes" : "No";
		
		$status = "Pending";
		if( $row['status'] == "In Progress" || $row['status'] == "Ready" || $row['status'] == "Delivered"){
			$status = $row['status'];
		}
		
		$payment_btn = "";
		if( $charge > 0 ){
			$payment_btn = "<a target='_blank' href='PayUMoneyBolt?rma_id=". $id ."' class='btn btn-primary btn-pay-now' style='display: inline-block'>Pay Now</a>";
		}
		
		$html_str .= '<tr>
							<td>'. $pname .'</td>
							<td>'. $sr .'</td>
							<td>'. $reg_date .'</td>
							<td><i class="fa fa-rupee"></i> '. $charge .'</td>
							<td>'. $status_text .'</td>
							<td><button class="btn btn-info adtnl-info" data-id="'.$id.'" data-sr="'.$sr.'" data-pname="'.$pname.'" data-cusname="'.$cus_name.'" data-mobile="'.$mobile.'" data-warranty="'.$warranty.'" data-regdate="'.$reg_date.'" data-invoice="'.$invoice.'" data-invcdate="'.$invoice_date.'" data-charge="'.$charge.'" data-chargeremark="'.$charge_remark.'" data-image="'.$image.'" data-status="'.$status.'" data-txnid="'.$txnid.'" data-payment-date="'.$payment_date.'" data-payment-status="'.$payment_status.'" data-cntct-prsn="'.$contact_person.'" data-address="'.$address.'">View Detail</button> '. $payment_btn .'</td>
						</tr>';
	}
			
	
	require_once("includes/header.php");
	require_once("includes/sidebar.php");
?>
	
	<div class="row">
		<div class="col-12">
			<div class="d-flex flex-wrap justify-content-between">
				<div>
					<h3 class="card-title m-0 pt-3">RMA Devices</h3>
				</div>
				<div>
					<div class="d-flex align-items-center">
					</div>
				</div>
			</div>
			<hr>
			
			<div class="card">
				<div class="card-body">
					<div class="table-responsive">
						<table class="table table-hover">
							<thead>
								<tr>
									<th>Product</th>
									<th>Serial Number</th>
									<th>RMA Date</th>
									<th>Amount</th>
									<th>Status</th>
									<th style="width:230px">Action</th>
								</tr>
							</thead>
							<tbody>
								<?php echo $html_str; ?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
			
		</div>
	</div>
	
	
	<div class="modal fade" id="adtnl-info-modal">
        <div class="modal-dialog">
            <div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title">Service Request</h4>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<table class="table">
						<tr>
							<th>RMA No.</th>
							<td id="iRmaNo"></td>
						</tr>
						<tr>
							<th>SR No.</th>
							<td id="iSrNo"></td>
						</tr>
						<tr>
							<th>Product</th>
							<td id="iPrd"></td>
						</tr>
						<tr>
							<th>Customer Name</th>
							<td id="iCusNm"></td>
						</tr>
						<tr>
							<th>Mobile No.</th>
							<td id="iCusMblNo"></td>
						</tr>
						<tr>
							<th>Contact Person</th>
							<td id="iCntctPrsn"></td>
						</tr>
						<tr>
							<th>Address</th>
							<td id="iAddrss"></td>
						</tr>
						<tr>
							<th>Warranty</th>
							<td id="iWarranty"></td>
						</tr>
						<tr>
							<th>RMA Registration Date</th>
							<td id="iRegDt"></td>
						</tr>
						<tr>
							<th>Invoice</th>
							<td id="iInvc"></td>
						</tr>
						<tr>
							<th>Invoice Date</th>
							<td id="iInvcDt"></td>
						</tr>
						<tr>
							<th>Service Charge</th>
							<td id="iSrvcChrg"></td>
						</tr>
						<tr>
							<th>Service Charge Remark</th>
							<td id="iSrvcChrgRmk"></td>
						</tr>
						<tr>
							<th>Status</th>
							<td id="iSts"></td>
						</tr>
						<tr id="iTxnidRow">
							<th>Transaction ID</th>
							<td id="iTxnid"></td>
						</tr>
						<tr id="iPymtDtRow">
							<th>Payment Date</th>
							<td id="iPymtDt"></td>
						</tr>
						<tr id="iPymtStsRow">
							<th>Payment Status</th>
							<td id="iPymtSts"></td>
						</tr>
						<tr>
							<th>Image</th>
							<td id="iImg"></td>
						</tr>
					</table>
				</div>
            </div>
        </div>
    </div>
	
<?php 

	require_once("includes/footer.php");
	
?>
                   