<?php 

	session_start();
	
	if(!isset($_SESSION['contact_mobile'])){
		header("location: login.php");
	}
	
	require_once("includes/constants.php");
	require_once("includes/config_db.php");
	require_once("includes/config.php");
	require_once("includes/ZohoBooks.php");
	
	$current_page = "estimates";
	$page_no = 1;
	$next_page = $prev_page = $html_str = $status = $status_options = $estimate_no = "";
	
	if( isset($_GET) && isset($_GET['page_no']) && intval($_GET['page_no']) > 0 ){
		$page_no = intval($_GET['page_no']);
	}
	
	if( isset($_GET) && isset($_GET['status']) && $_GET['status'] != "" ){
		$status = $_GET['status'];
	}
	
	if( isset($_POST['search-estimate']) ){
		$estimate_no = $_POST['estimate-no'];
	}
	
	$status_options .= ($status=="") ? '<option value="" selected>All</option>' : '<option value="">All</option>';
	$status_options .= ($status=="accepted") ? '<option value="accepted" selected>Accepted</option>' : '<option value="accepted">Accepted</option>';
	$status_options .= ($status=="declined") ? '<option value="declined" selected>Declined</option>' : '<option value="declined">Declined</option>';
	$status_options .= ($status=="draft") ? '<option value="draft" selected>Draft</option>' : '<option value="draft">Draft</option>';
	$status_options .= ($status=="expired") ? '<option value="expired" selected>Expired</option>' : '<option value="expired">Expired</option>';
	$status_options .= ($status=="invoiced") ? '<option value="invoiced" selected>Invoiced</option>' : '<option value="invoiced">Invoiced</option>';
	$status_options .= ($status=="sent") ? '<option value="sent" selected>Sent</option>' : '<option value="sent">Sent</option>';
	
	$zb = new ZohoBooks(ZOHO_AUTHTOKEN, ZOHO_ORGANIZATIONID);
	
	$config = array(
					"customer_id" => $_SESSION['contact_id'],
					"page" => $page_no,
				);
	
	if( $status != "" ){
		$config["status"] = $status;
	}
	if( $estimate_no != "" ){
		$config["estimate_number"] = $estimate_no;
	}

	$estimates = $zb->allEstimates($config);
	

	$response = json_decode($estimates, true);
	
	if( is_array($response) ){
		$estimates = $response['estimates'];
		$page_context = $response['page_context'];
		$max = sizeof($estimates);
		
		/*echo "<pre>";
		print_r($estimates[0]);
		echo "</pre>";
		
		echo "<pre>";
		print_r($page_context);
		echo "</pre>";*/
		
		for($i=0; $i<$max; $i++){
			$aprv_btn = "";
			if( $estimates[$i]['status'] == "draft" ){
				$aprv_btn = '<button class="btn btn-dark approve-estimate" data-estimate-id="'. $estimates[$i]['estimate_id'] .'">Approve</button>';
			}
			
			$status_class = "badge-primary";
		
			if( $estimates[$i]['status'] == "accepted" ){
				$status_class = "badge-info";
			}else if( $estimates[$i]['status'] == "declined" ){
				$status_class = "badge-danger";
			}else if( $estimates[$i]['status'] == "draft" ){
				$status_class = "badge-secondary";
			}else if( $estimates[$i]['status'] == "expired" ){
				$status_class = "badge-warning";
			}else if( $estimates[$i]['status'] == "invoiced" ){
				$status_class = "badge-success";
			}else if( $estimates[$i]['status'] == "sent" || $estimates[$i]['status'] == "approved" ){
				$status_class = "badge-info";
			}
			
			$html_str .= '<tr>
							<td>'. $estimates[$i]['estimate_number'] .'</td>
							<td>'. date('d-M-Y', strtotime($estimates[$i]['date'])) .'</td>
							<td><i class="fa fa-rupee"></i> '. $estimates[$i]['total'] .'</td>
							<td><span class="badge '. $status_class .'">'. ucfirst($estimates[$i]['status']) .'</span></td>
							<td><a href="download.php?estimate_id='. $estimates[$i]['estimate_id'] .'&estimate_number='. $estimates[$i]['estimate_number'] .'" target="_blank"><i class="fa fa-cloud-download" style="font-size: 1.3rem;"></i></a></td>
						</tr>';
		}
		
		if( $page_no > 1 ){
			$prev_page = "estimates.php?page_no=" . ($page_no - 1);
			
			if( isset($_GET) && isset($_GET['status']) && $_GET['status'] != "" ){
				$prev_page .= "&status=" . $_GET['status'];
			}
		}
		
		if( $page_context['has_more_page'] ){
			$page_no++;
			
			$next_page = "estimates.php?page_no=" . $page_no;
			
			if( isset($_GET) && isset($_GET['status']) && $_GET['status'] != "" ){
				$next_page .= "&status=" . $_GET['status'];
			}
		}
	}
	
	require_once("includes/header.php");
	require_once("includes/sidebar.php");
?>
	
	<div class="row">
		<div class="col-12">
			<div class="d-flex flex-wrap justify-content-between">
				<div>
					<h3 class="card-title m-0 pt-3">Estimates</h3>
				</div>
				<div>
					<div class="d-flex align-items-center">
						<select class="form-control" id="statusFltr">
							<?php echo $status_options; ?>
						</select>
					</div>
				</div>
			</div>
			<hr>
			
			<div class="card">
				<div class="card-body">
					<div class="row">
						<div class="col"></div>
						<div class="col-4">
							<div class="form-group">
								<form method="POST" action="">
									<div class="input-group">
										<div class="input-group-prepend">
											<span class="input-group-text">Estimate Number</span>
										</div>
										<input type="text" class="form-control" name="estimate-no" value="<?php if(isset($estimate_no) && $estimate_no != ""){ echo $estimate_no; } ?>">
										<div class="input-group-append">
											<button class="btn btn-sm btn-primary" name="search-estimate" type="submit">Search</button>
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
					<div class="table-responsive">
						<table class="table table-hover">
							<thead>
								<tr>
									<th>Estimate Number</th>
									<th>Date</th>
									<th>Total</th>
									<th>Status</th>
									<th>Download</th>
								</tr>
							</thead>
							<tbody>
								<?php echo $html_str; ?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
			
			
			<?php if( (isset($prev_page) && $prev_page != "") || (isset($next_page) && $next_page != "") ){ ?>
			<div class="row mt-4">
				<div class="col-auto">
					<?php if(isset($prev_page) && $prev_page != ""){ ?>
					<a href="<?php echo $prev_page; ?>" class="btn btn-inverse-dark btn-fw">Previous</a>
					<?php } ?>
				</div>
				<div class="col"></div>
				<div class="col-auto">
					<?php if(isset($next_page) && $next_page != ""){ ?>
					<a href="<?php echo $next_page; ?>" class="btn btn-inverse-dark btn-fw">Next</a>
					<?php } ?>
				</div>
			</div>
			<?php }?>
		</div>
	</div>
	
<?php 

	require_once("includes/footer.php");
	
?>
                    