(function($) {
	'use strict';
	$(function() {
		
		$("#requestTbl").on("click", ".complaint-history", function(){
			$("#mainLoader").show();
			
			var complaintId = $(this).closest("tr").attr("data-complaint-id");
			
			$.ajax({
				type: "POST",
				url: "ajax/ajaxCall.php",
				dataType: "json",
				data: {
					method: 'getComplaintHistory',
					complaintId: complaintId
				},
				success: function(response){
					var loopLimit = response.length;
					var tbodyRow = '', stsStr = '';
					for(var y=0; y<loopLimit; y++){
						stsStr = "";
						if(response[y].status=='Registered'){
							stsStr = '<span class="badge badge-warning">Registered</span>';
						}else if( response[y].status == "In Progress" ){
							stsStr = '<span class="badge badge-info">In Progress</span>';
						}else if( response[y].status == "Resolved" ){
							stsStr = '<span class="badge badge-success">Resolved</span>';
						}
		
						tbodyRow += '<tr>'+
										'<td>' + response[y].remark + '</td>'+
										'<td>' + response[y].updated_on + '</td>'+
										'<td>' + stsStr + '</td>'+
									'</tr>';
					}
					$("#requestHistoryTbl tbody").html(tbodyRow);
					$("#requestHistoryModal").modal("show");
					
					$("#mainLoader").hide();
				},
				error: function( jqXHR, textStatus, errorThrown){
					console.log(jqXHR);
					console.log(textStatus);
					console.log(errorThrown);
					$("#mainLoader").hide();
				}
			});
		});
	});
})(jQuery);