<?php 

	require_once("../includes/constants.php");
	require_once("../includes/config_db.php");
	require_once("../includes/config.php");
	require_once("../includes/ZohoBooks.php");
	
	if( isset($_POST) && isset($_POST['method']) ){
		switch($_POST['method']){
			case "getComplaintHistory":
				$complaint_id = $_POST["complaintId"];
				getComplaintHistory($complaint_id);
				break;
				
			case "approveEstimate":
				$estimate_id = $_POST["estimateId"];
				approveEstimate($estimate_id);
				break;
				
			case "sendOtp":
				$mobileNo = $_POST["mobileNo"];
				sendOtp($mobileNo);
				break;
				
			default:
				break;
		}
	}
	
	function getComplaintHistory($complaint_id){
		global $dbh;
		
		$response = array();
		
		$sql_query = " SELECT * FROM complaint_history WHERE complaint_id = '$complaint_id' ORDER BY id DESC";
		$stmt = $dbh->query($sql_query);
		
		while($row = $stmt->fetch( PDO::FETCH_ASSOC)){
			$history = array(
				"status" => $row["status"],
				"remark" => $row["remark"],
				"updated_on" => date("d/m/Y H:i:s", strtotime($row['updated_on'])),
			);
			
			array_push($response, $history);
		}

		echo json_encode($response);
	}
	
	function sendOtp($mobileNo){
		$digits = 6;
		$otp = rand(pow(10, $digits-1), pow(10, $digits)-1);
		$message = "Your OTP to login into servius client portal is " . $otp;
		
		$response = array(
						"otp" => md5($otp)
					);
		
		sendSMS($message, $mobileNo);
		
		echo json_encode($response);
	}
	
	function approveEstimate($estimate_id){
		$zb = new ZohoBooks(ZOHO_AUTHTOKEN, ZOHO_ORGANIZATIONID);
	
		$config = array(
						"estimate_id" => $estimate_id,
					);

		$response = $zb->approveEstimates($config);
		
		echo json_encode($response);
	}
?>